/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalTabs = Object.create(STBModule.prototype);

STBGlobalTabs.name = "GlobalTabs";

STBGlobalTabs.initTabs = function () {

	var elements = $('.tabs-container:not(.__done)');

	if (elements.length) {
		elements.easytabs({
			updateHash		: false,
			tabActiveClass	: "active",
			animate			: false,
			transitionIn	: "slideDown",
			transitionOut	: "slideUp",
			animationSpeed	: "slow"
		});

		elements.addClass("__done");
	}

}


STBGlobalTabs.runOnReady = function() {
	STBGlobalTabs.initTabs();
}

STBGlobalTabs.runOnContentUpdate = function() {
	STBGlobalTabs.initTabs();
}


site.registerModule(STBGlobalTabs);
